<?php

@set_time_limit(0);
@ini_set('memory_limit', '-1');
@ini_set('max_execution_time', 0);
error_reporting(0);

$configFile = __DIR__ . '/application/config/app-config.php';

$db_host = '';
$db_user = '';
$db_pass = '';
$db_name = '';

if (file_exists($configFile)) {
    $content = file_get_contents($configFile);
    if (preg_match("/define\('APP_DB_HOSTNAME',\s*'(.+?)'\);/", $content, $m)) $db_host = $m[1];
    if (preg_match("/define\('APP_DB_USERNAME',\s*'(.+?)'\);/", $content, $m)) $db_user = $m[1];
    if (preg_match("/define\('APP_DB_PASSWORD',\s*'(.+?)'\);/", $content, $m)) $db_pass = $m[1];
    if (preg_match("/define\('APP_DB_NAME',\s*'(.+?)'\);/", $content, $m))     $db_name = $m[1];
} else {
    die("Error: Configuration file $configFile not found. Please ensure the script is in the website root directory.");
}

$mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($mysqli->connect_error) {
    die("Database connection failed: " . $mysqli->connect_error);
}
$mysqli->set_charset("utf8");

$action = isset($_POST['action']) ? $_POST['action'] : '';
$msg = '';

if ($action === 'count') {
    $sql = "SELECT count(*) as total FROM `tblcontacts`";
    $result = $mysqli->query($sql);
    if ($result) {
        $row = $result->fetch_assoc();
        $msg = "Table `tblcontacts` Total Rows: <strong style='color:red;font-size:20px'>" . $row['total'] . "</strong>";
    } else {
        $msg = "Query Failed: " . $mysqli->error;
    }
} 
elseif ($action === 'export') {
    $filename = 'contacts_export_' . date('Ymd_His') . '.csv';
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    
    $output = fopen('php://output', 'w');
    
    fputs($output, "\xEF\xBB\xBF");
    
    $sql = "SELECT * FROM `tblcontacts`";
    if ($result = $mysqli->query($sql, MYSQLI_USE_RESULT)) {
        
        $fields = $result->fetch_fields();
        $headers = [];
        foreach ($fields as $field) {
            $headers[] = $field->name;
        }
        fputcsv($output, $headers);
        
        while ($row = $result->fetch_row()) {
            fputcsv($output, $row);
        }
        
        $result->close();
    } else {
        echo "Export Error: " . $mysqli->error;
    }
    
    fclose($output);
    $mysqli->close();
    exit(); 
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Perfex CRM Data Tool</title>
    <style>
        body { font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; background: #f3f3f3; display: flex; justify-content: center; padding-top: 50px; }
        .container { background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 500px; text-align: center; }
        h2 { margin-top: 0; color: #333; }
        .db-info { margin-bottom: 20px; font-size: 12px; color: #777; text-align: left; background: #eee; padding: 10px; border-radius: 4px; }
        .btn-group { margin-top: 20px; display: flex; justify-content: space-around; }
        button { padding: 10px 20px; font-size: 16px; border: none; border-radius: 4px; cursor: pointer; transition: background 0.3s; }
        .btn-count { background: #2196F3; color: white; }
        .btn-count:hover { background: #0b7dda; }
        .btn-export { background: #4CAF50; color: white; }
        .btn-export:hover { background: #45a049; }
        .result-box { margin-top: 20px; padding: 15px; border: 1px dashed #ccc; background: #fafafa; min-height: 20px; }
    </style>
</head>
<body>

<div class="container">
    <h2>CRM Data Extractor</h2>
    
    <div class="db-info">
        <strong>Database:</strong> <?php echo htmlspecialchars($db_name); ?><br>
        <strong>Host:</strong> <?php echo htmlspecialchars($db_host); ?><br>
        <strong>Status:</strong> <span style="color:green">Connected</span>
    </div>

    <form method="POST">
        <div class="btn-group">
            <button type="submit" name="action" value="count" class="btn-count">
                = Count Data
            </button>
            
            <button type="submit" name="action" value="export" class="btn-export">
                = Export CSV
            </button>
        </div>
    </form>

    <?php if ($msg): ?>
    <div class="result-box">
        <?php echo $msg; ?>
    </div>
    <?php endif; ?>
</div>

</body>
</html>